/** An address is made up of a String representing the Street, a city, a state, and a zip code
 * @author Braskin, Aaron
 * @version March 20th, 2015
 */
public class Address {
	// CONSTANTS
	public static final String[] STATE_ABBREVIATIONS={"AK","AL","AR","AZ","CA","CO","CT","DC",
		"DE","FL","GA","HI","IA","ID","IL","IN","KS","KY","LA","MA","MD","ME","MI","MN","MO",
		"MS","MT","NC","ND","NE","NH","NJ","NM","NV","NY","OH","OK","OR","PA","RI","SC","SD",
		"TN","TX","UT","VA","VT","WA","WI","WV","WY"};
	// CLASS METHODS
	/**
	 * Given a string, this method returns true if the upper case of that string matches a
	 * standard two letter code for one of the United States of America
	 * @param possibleState the string to check
	 * @return <code>true</code> only if <code>possibleState</code> is an upper or
	 * lower case two letter state abbreviation
	 */
	public static boolean isValidStateAbreviation(String possibleState) {
		if (possibleState==null) return false;
		for (String theStateToCheck:STATE_ABBREVIATIONS) {
			if (theStateToCheck.equals(possibleState.toUpperCase())) {
				return true;
			}
		}
		return false;
	}

	/**
	 * Determines if the parameter is a five digit string
	 * @param possibleZip the string to check
	 * @return <code>true</code> only if <code>possibleZip</code> is exactly 5 digits
	 */
	// public static boolean isValidZip(String possibleZip)

	// INSTANCE VARIABLES

	// CONSTRUCTORS
	/** The default constructor makes the Street, City, State, and ZIP Code empty strings. */
	// public Address()
	// 
	/** This constructor sets the Street, City, State, and ZIP Code or makes them empty
	 * strings if a <code>null</code> or invalid value is given.
	 * @param setStreet the Street Address
	 * @param setCity the City
	 * @param setState the two letter State abbreviation
	 * @param setZip the 5 digit Zip Code
	 */
	// public Address(String setStreet, String setCity, String setState, String setZip)
	
	// GETTER METHODS
	/** @return the street address */
	// public String getStreet()

	/** @return the city part of the address */
	// public String getCity()

	/** @return the upper case two-letter State abbreviation */
	// public String getState()

	/** @return the 5 digit zip code as a <code>String</code> */
	// public String getZip()

	/**
	 * Returns the complete address as a <code>String</code> starting in:
	 * Street
	 * City, ST ZIP
	 */
	// public String toString()

	// SETTER METHODS
	/** 
	 * Sets the field if the parameter is not null, otherwise it remains unchanged
	 * @param setStreet the street address
	 */
	// public void setStreet(String setStreet)

	/**
	 * Sets the field if the parameter is not null, otherwise it remains unchanged
	 * @param setCity the city
	 */
	// public void setCity(String setCity)
	
	/**
	 * Sets the field to the upper case of the parameter if it is not <code>null<code>
	 * and is a valid two letter state abbreviation, otherwise it remains unchanged
	 * @param setState a valid two letter state abbreviation 
	 */
	// public void setState(String setState)
	/**
	 * Sets the field if the parameter is a valid 5 digit United States Zip Code
	 * @param setZip a valid 5 digit zip code
	 */
	// public void setZip(String setZip)
}
