/** This class store a name as a separate first and last name. The first and last name will never
 * be <code>null</code>. The class will also be able to return the name in both first name then
 * last format and last name first format.
 * @author Aaron Braskin
 * @version March 18th, 2015
 */
public class Name {
	// Constants
	
	// Instance Variables
	private String first;
	private String last;
	
	// Constructor Methods
	/** The default constructor initializes both first and last to be an empty string */
	public Name() {
		first="";
		last="";
	}
	/** This constructor sets first and last equal to the parameter values if they are not
	 * <code>null</code> and makes each an empty strings if its respective parameter is
	 * <code>null</code> 
	 * @param setFirst the first name
	 * @param setLast the last name
	 */
	public Name(String setFirst, String setLast) {
		if (setFirst!=null) {
			first=setFirst;
		} else {
			first="";
		}
		last=setLast;
		if (last==null) last="";
	}
	// Getter Methods
	/** @return the first name */
	public String getFirst() {
		return first;
	}
	/** @return the last name */
	public String getLast() {
		return last;
	}
	/** @return the name in first-space-last format */
	public String toString() {
		return first+" "+last;
	}
	/** @return the name in last, first format */
	public String getLastNameFirst() {
		return last+", "+first;
	}
	/** @return true when both first and last are equal */
	public boolean equals(Object otherObject) {
		if (otherObject instanceof Name) {
			Name otherName=(Name)otherObject;
			return first.equals(otherName.getFirst()) && last.equals(otherName.getLast());
		} else {
			return super.equals(otherObject);
		}
	}
	// Setter Methods
	/** Sets a new first name if the parameter is not <code>null</code> */
	public void setFirst(String setFirst) {
		if (setFirst!=null) first=setFirst;
	}
	/** Sets a new last name if the parameter is not <code>null</code> */
	public void setLast(String setLast) {
		if (setLast!=null) last=setLast;
	}
}








