/*
 * Decompiled with CFR 0.152.
 */
public class AddressTest {
    private static double points = 0.0;
    private static double maxPoints = 0.0;
    public static final String VERSION = "March 25, 2015 version 1.2";

    private static String formatOut(String s, boolean isString) {
        if (s == null) {
            return "null";
        }
        if (isString) {
            return "\"" + s + "\"";
        }
        return s;
    }

    public static void score() {
        System.out.println("March 25, 2015 version 1.2\n");
        try {
            System.out.println("Default Constructor() and Getters: ");
            Address a = new Address();
            AddressTest.test("Street", a.getStreet(), "", 0.2, true);
            AddressTest.test("City", a.getCity(), "", 0.2, true);
            AddressTest.test("State", a.getState(), "", 0.2, true);
            AddressTest.test("ZIP", a.getZip(), "", 0.2, true);
            System.out.println("\nnew Address() and Getters): ");
            a = new Address("325 S. Peck Avenue", "Manhattan Beach", "CA", "90266");
            AddressTest.test("Street", a.getStreet(), "325 S. Peck Avenue", 0.25, true);
            AddressTest.test("City", a.getCity(), "Manhattan Beach", 0.25, true);
            AddressTest.test("State", a.getState(), "CA", 0.25, true);
            AddressTest.test("ZIP", a.getZip(), "90266", 0.5, true);
            AddressTest.test("\n.toString()", a.toString(), "325 S. Peck Avenue\nManhattan Beach, CA 90266", 1.0, true);
            System.out.println("\nnew Address(null,null,null,null) and Getters): ");
            a = new Address(null, null, null, null);
            AddressTest.test("Street", a.getStreet(), "", 0.25, true);
            AddressTest.test("City", a.getCity(), "", 0.25, true);
            AddressTest.test("State", a.getState(), "", 0.5, true);
            AddressTest.test("ZIP", a.getZip(), "", 0.5, true);
            System.out.println("\nnew Address(null,null,\"XY\",\"9026\") and Getters): ");
            a = new Address(null, null, "XY", "9026");
            AddressTest.test("State", a.getState(), "", 0.2, true);
            AddressTest.test("ZIP", a.getZip(), "", 0.5, true);
            System.out.println("\nnew Address(null,null,\"ca\",\"9o266\") and Getters): ");
            a = new Address(null, null, "ca", "9o266");
            AddressTest.test("State", a.getState(), "CA", 0.25, true);
            AddressTest.test("ZIP", a.getZip(), "", 0.5, true);
            a = new Address(null, null, null, null);
            System.out.println("\n.getStreet=" + AddressTest.formatOut(a.getStreet(), true));
            a.setStreet("325 S. Peck Avenue");
            AddressTest.test(".setStreet(\"325 S. Peck Avenue\")", a.getStreet(), "325 S. Peck Avenue", 0.25, true);
            a = new Address("325 S. Peck Avenue", null, null, null);
            System.out.println("\n.getStreet=" + AddressTest.formatOut(a.getStreet(), true));
            a.setStreet(null);
            AddressTest.test(".setStreet(null)", a.getStreet(), "325 S. Peck Avenue", 0.25, true);
            a = new Address(null, "Manhattan Beach", null, null);
            System.out.println("\n.getCity=" + AddressTest.formatOut(a.getCity(), true));
            a.setCity(null);
            AddressTest.test(".setCity(null)", a.getCity(), "Manhattan Beach", 0.25, true);
            a = new Address(null, null, null, null);
            System.out.println("\n.getCity=" + AddressTest.formatOut(a.getCity(), true));
            a.setCity("Manhattan Beach");
            AddressTest.test(".setCity(\"Manhattan Beach\")", a.getCity(), "Manhattan Beach", 0.25, true);
            a = new Address(null, null, null, null);
            System.out.println("\n.getState=" + AddressTest.formatOut(a.getState(), true));
            a.setState("CA");
            AddressTest.test(".setState(\"CA\")", a.getState(), "CA", 0.25, true);
            a = new Address(null, null, null, null);
            System.out.println("\n.getState=" + AddressTest.formatOut(a.getState(), true));
            a.setState("ca");
            AddressTest.test(".setState(\"ca\")", a.getState(), "CA", 0.25, true);
            a = new Address(null, null, "CA", null);
            System.out.println("\n.getState=" + AddressTest.formatOut(a.getState(), true));
            a.setState(null);
            AddressTest.test(".setState(null)", a.getState(), "CA", 0.25, true);
            a = new Address(null, null, "CA", null);
            System.out.println("\n.getState=" + AddressTest.formatOut(a.getState(), true));
            a.setState("XY");
            AddressTest.test(".setState(\"XY\")", a.getState(), "CA", 0.25, true);
            a = new Address(null, null, "NY", null);
            System.out.println("\n.getState=" + AddressTest.formatOut(a.getState(), true));
            a.setState("WA");
            AddressTest.test(".setState(\"WA\")", a.getState(), "WA", 0.25, true);
            a = new Address(null, null, null, null);
            System.out.println("\n.getZip=" + AddressTest.formatOut(a.getState(), true));
            a.setZip("90266");
            AddressTest.test(".setZip(\"90266\")", a.getZip(), "90266", 0.25, true);
            a = new Address(null, null, null, "90266");
            System.out.println("\n.getZip=" + AddressTest.formatOut(a.getZip(), true));
            a.setZip(null);
            AddressTest.test(".setZip(null)", a.getZip(), "90266", 0.25, true);
            a = new Address(null, null, null, "90266");
            System.out.println("\n.getZip=" + AddressTest.formatOut(a.getZip(), true));
            a.setZip("9o266");
            AddressTest.test(".setZip(\"9o266\")", a.getZip(), "90266", 0.5, true);
            a = new Address(null, null, null, "90266");
            System.out.println("\n.getZip=" + AddressTest.formatOut(a.getZip(), true));
            a.setZip("902666");
            AddressTest.test(".setZip(\"902666\")", a.getZip(), "90266", 0.25, true);
            a = new Address(null, null, null, "90248");
            System.out.println("\n.getZip=" + AddressTest.formatOut(a.getZip(), true));
            a.setZip("90266");
            AddressTest.test(".setZip(\"90266\")", a.getZip(), "90266", 0.5, true);
            System.out.println("Total Points: " + (double)((int)((points + 0.005) * 100.0)) / 100.0 + "/" + (double)((int)((maxPoints + 0.005) * 100.0)) / 100.0);
        }
        catch (Exception e) {
            System.out.println("Java Exception Error, no submission allowed.");
        }
        catch (Error e) {
            System.out.println("Java Language Error, no submission allowed.");
        }
    }

    private static boolean test(String label, String studentAnswer, String correctAnswer, double pointVal, boolean useQuotes) {
        double scored = 0.0;
        boolean isCorrect = false;
        System.out.print(String.valueOf(label) + "=" + AddressTest.formatOut(studentAnswer, useQuotes));
        System.out.print(", should be " + AddressTest.formatOut(correctAnswer, useQuotes));
        if (studentAnswer == null && correctAnswer == null || studentAnswer != null && studentAnswer.equals(correctAnswer)) {
            scored = pointVal;
            points += pointVal;
            isCorrect = true;
        }
        maxPoints += pointVal;
        System.out.println(" [" + scored + "/" + pointVal + "]");
        return isCorrect;
    }
}

