public class AddressTest {
	private static double points=0.0, maxPoints=0.0;
	public static final String VERSION="March 25, 2015 version 1.2";
	private static String formatOut(String s, boolean isString) {
		if (s==null) return "null";
		if (isString) return "\""+s+"\"";
		return ""+s;
	}
	public static void score() {
		System.out.println(VERSION+"\n");
		try {
			System.out.println("Default Constructor() and Getters: ");
			Address a=new Address();
			
			test("Street",a.getStreet(),"",.2,true);
			test("City",a.getCity(),"",.2,true);
			test("State",a.getState(),"",.2,true);
			test("ZIP",a.getZip(),"",.2,true);

			System.out.println("\nnew Address() and Getters): ");
			a=new Address("325 S. Peck Avenue","Manhattan Beach","CA","90266");
			test("Street",a.getStreet(),"325 S. Peck Avenue",.25,true);
			test("City",a.getCity(),"Manhattan Beach",.25,true);
			test("State",a.getState(),"CA",.25,true);
			test("ZIP",a.getZip(),"90266",.5,true);

			test("\n.toString()",a.toString(),"325 S. Peck Avenue\nManhattan Beach, CA 90266",1,true);
			
			System.out.println("\nnew Address(null,null,null,null) and Getters): ");
			a=new Address(null,null,null,null);
			test("Street",a.getStreet(),"",.25,true);
			test("City",a.getCity(),"",.25,true);
			test("State",a.getState(),"",.5,true);
			test("ZIP",a.getZip(),"",.5,true);

			System.out.println("\nnew Address(null,null,\"XY\",\"9026\") and Getters): ");
			a=new Address(null,null,"XY","9026");
			test("State",a.getState(),"",.2,true);
			test("ZIP",a.getZip(),"",.5,true);

			System.out.println("\nnew Address(null,null,\"ca\",\"9o266\") and Getters): ");
			a=new Address(null,null,"ca","9o266");
			test("State",a.getState(),"CA",.25,true);
			test("ZIP",a.getZip(),"",.5,true);

			a=new Address(null,null,null,null);			
			System.out.println("\n.getStreet="+formatOut(a.getStreet(),true));
			a.setStreet("325 S. Peck Avenue");
			test(".setStreet(\"325 S. Peck Avenue\")",a.getStreet(),"325 S. Peck Avenue",.25,true);
			
			a=new Address("325 S. Peck Avenue",null,null,null);
			System.out.println("\n.getStreet="+formatOut(a.getStreet(),true));
			a.setStreet(null);
			test(".setStreet(null)",a.getStreet(),"325 S. Peck Avenue",.25,true);

			a=new Address(null,"Manhattan Beach",null,null);			
			System.out.println("\n.getCity="+formatOut(a.getCity(),true));
			a.setCity(null);
			test(".setCity(null)",a.getCity(),"Manhattan Beach",.25,true);
			
			a=new Address(null,null,null,null);			
			System.out.println("\n.getCity="+formatOut(a.getCity(),true));
			a.setCity("Manhattan Beach");
			test(".setCity(\"Manhattan Beach\")",a.getCity(),"Manhattan Beach",.25,true);
			
			a=new Address(null,null,null,null);			
			System.out.println("\n.getState="+formatOut(a.getState(),true));
			a.setState("CA");
			test(".setState(\"CA\")",a.getState(),"CA",.25,true);
					
			a=new Address(null,null,null,null);			
			System.out.println("\n.getState="+formatOut(a.getState(),true));
			a.setState("ca");
			test(".setState(\"ca\")",a.getState(),"CA",.25,true);
			
			a=new Address(null,null,"CA",null);			
			System.out.println("\n.getState="+formatOut(a.getState(),true));
			a.setState(null);
			test(".setState(null)",a.getState(),"CA",.25,true);
			
			a=new Address(null,null,"CA",null);			
			System.out.println("\n.getState="+formatOut(a.getState(),true));
			a.setState("XY");
			test(".setState(\"XY\")",a.getState(),"CA",.25,true);
			
			a=new Address(null,null,"NY",null);			
			System.out.println("\n.getState="+formatOut(a.getState(),true));
			a.setState("WA");
			test(".setState(\"WA\")",a.getState(),"WA",.25,true);
			
			a=new Address(null,null,null,null);			
			System.out.println("\n.getZip="+formatOut(a.getState(),true));
			a.setZip("90266");
			test(".setZip(\"90266\")",a.getZip(),"90266",.25,true);
			
			a=new Address(null,null,null,"90266");			
			System.out.println("\n.getZip="+formatOut(a.getZip(),true));
			a.setZip(null);
			test(".setZip(null)",a.getZip(),"90266",.25,true);
			
			a=new Address(null,null,null,"90266");			
			System.out.println("\n.getZip="+formatOut(a.getZip(),true));
			a.setZip("9o266");
			test(".setZip(\"9o266\")",a.getZip(),"90266",.5,true);
			
			a=new Address(null,null,null,"90266");			
			System.out.println("\n.getZip="+formatOut(a.getZip(),true));
			a.setZip("902666");
			test(".setZip(\"902666\")",a.getZip(),"90266",.25,true);
			
			a=new Address(null,null,null,"90248");			
			System.out.println("\n.getZip="+formatOut(a.getZip(),true));
			a.setZip("90266");
			test(".setZip(\"90266\")",a.getZip(),"90266",.5,true);
			System.out.println("Total Points: "+((int)((points+.005)*100))/100.0+"/"+((int)((maxPoints+.005)*100))/100.0);			
		} catch(Exception e) {
			System.out.println("Java Exception Error, no submission allowed.");
		} catch (Error e) {
			System.out.println("Java Language Error, no submission allowed.");
		}
	}
	private static boolean test(String label, String studentAnswer, String correctAnswer, double pointVal, boolean useQuotes) {
		double scored=0.0;
		boolean isCorrect=false;
		System.out.print(label+"="+formatOut(studentAnswer,useQuotes));
//		if (useQuotes && studentAnswer!=null) System.out.print("\"");
//		System.out.print(studentAnswer);
//		if (useQuotes && studentAnswer!=null) System.out.print("\"");
		System.out.print(", should be "+formatOut(correctAnswer,useQuotes));
//		if (useQuotes && correctAnswer!=null) System.out.print("\"");
//		System.out.print(correctAnswer);
//		if (useQuotes && correctAnswer!=null) System.out.print("\"");
		if ((studentAnswer==null && correctAnswer==null) || (studentAnswer!=null && studentAnswer.equals(correctAnswer))) {
			scored=pointVal;
			points+=pointVal;
			isCorrect=true;
		}
		maxPoints+=pointVal;
		System.out.println(" ["+scored+"/"+pointVal+"]");
		return isCorrect;
	}
}
