import java.util.ArrayList;
import java.util.List;

/** The contact class will store one name and a List of Address. The first Address in the list is the
 *  primary address that is used for the contact.
 * @author Aaron Braskin
 * @version March 24th, 2015
 */
public class Contact implements Comparable<Contact> {
	// Constants

	// Instance Variables
	/* FOR EVALUATION PURPOSES, THESE INSTANCE VARIABLES MUST NOT BE RENAMED! */
	private Name thePerson;
	private List<Address> theAddresses;

	/** The default constructor will instantiate a new <code>Name</code> object using the default constructor
	 *  of the Name class and then instantiate a new <code>ArrayList</code> of <code>Address</code>.
	 *  Finally, a new <code>Address</code> object will be instantiated using the default constructor for the
	 *  Address class.
	 */
	public Contact() {
	}
	/** This overloaded constructor takes a <code>Name</code> object and an <code>Address</code> object as parameters.
	 *  These are then used to instantiate <em>new</em> <code>Name</code> and <code>Address</code> objects.
	 *  Next, it instantiates a new <code>ArrayList</code> of <code>Address</code> and then set the contact's fields
	 *  using the newly instantiated objects.
	 *  If <code>setPerson</code> or <code>setAddress</code>is <code>null</code> then create a new object using the
	 *  respective default constructor instead.
	 * @param setPerson the <code>Name</code> to be copied to the new contact
	 * @param setAddress the <code>Address</code> to be copied to the new contact
	 */
	public Contact(Name setPerson, Address setAddress) {
	}
	/** Returns the name in First Last format with the primary address on the following two lines
	 * @return the Name and primary address
	 */
	public String toString() {
	}
	/** Sets the first and last name if <code>setPerson</code> is not <code>null</code>*/
	public void setPerson(Name setPerson) {
	}
	/** Gets the contact's name 
	 * @return the contacts name
	 */
	public String getName() {
	}
	/** Gets the contact's name in last name first format
	 * @return the contacts last name, first name
	 */
	public String getLastNameFirst() {
	}
	/** Returns this contacts primary address (the first one created unless it has been changed)
	 * @return the primary address for this contact
	 */
	public String getPrimaryAddress() {
	}
	/** Compares to <code>Contact</code> objects using the names in last, first format
	 * @param otherContact
	 * @return 	a negative integer, zero, or a positive integer as this object is less than, equal to, or
	 * greater than the specified object.
	 */
	public int compareTo(Contact otherContact) {
	}
	/** Adds the new address if <code>anotherAddress</code> is not <code>null</code> by creating a copy
	 * of <code>anotherAddress</code> and makes it the primary address if <code>isPrimary</code> is 
	 * <code>true</code>
	 * @param anotherAddress the address to add
	 * @param isPrimary if <code>true</code> the new address is set as the primary address for this contact
	 */
	public void addAddress(Address anotherAddress, boolean isPrimary) {
		/* Your code goes here */
		// 1. Return if anotherAddress is null
		// 2. Create a local Strings to hold the street, city, state, and zip from anotherAddress
		// 3. Use the local Strings to instantiate a new Address object
		// 4. Add the Address object to front or end of the list if isPrimary is true or false 
	}
	/** If the <code>addressIndex</code> is valid, it makes the primary address the one at address index
	 * 
	 * @param addressIndex the index of the new primary address
	 * @return <code>true</code> if a new address has been made the primary address
	 */
	public boolean setPrimaryAddress(int addressIndex) {
		/* Your code goes here */
		// 1. Return false if addressIndex is not valid
		// 2. Set the address at index 0 to be the address at addressIndex, storing the address originally there
		// 3. Put the address that was at index 0 back into the list
		// 4. Return true
		return false;
	}
	/** Returns the address at the specified index if the index is valid, otherwise it returns the primary
	 * address
	 * @param addressIndex the index of the address to return
	 * @return the <code>Address</code> at <code>addressIndex</code>
	 */
	public String getAddress(int addressIndex) {
		/* Your code goes here */
		// 1. Return the primary address if addressIndex is not valid
		// 2. Return the address at addressIndex
		return null;
	}
	/** Removes the address at <code>addressIndex</code> if it is not the primary address and it is a valid index
	 * @param addressIndex the index of the address to be removed
	 * @return <code>true</code> if the address was removed
	 */
	public boolean removeAddress(int addressIndex) {
		/* Your code goes here */
		// 1. Return false if addressIndex is not valid
		// 2. Remove the address at addressIndex from the list
		// 3. Return true
		return false;
	}
	/** Returns a String where each address associate with this Contact is in two consecutive lines with the
	 * primary address listed first.
	 * @return all the addresses for the contact with the primary address first
	 */
	public String getAllAddresses() {
		/* Your code goes here */
		// 1. Create an accumulator String
		// 2. Use a loop to concatenate each address from the list with a newline after all but the last one
		// 3. Return the accumulator String
		return null;
	}
}