import java.util.ArrayList;
import java.util.List;

/** The NameRunner class is designed to demonstrate the use of the List interface
 * and the ArrayList class. The following ArrayList methods will be demonstrated: 
 * Constructor
 * add
 * get
 * set
 * remove
 * size
 * equals
 * 
 * Finally, the use of the special form of for loop known colloquially as the
 * "for each" loop will be demonstrated. 
 * @author Aaron Braskin
 * @version March 17th, 2015
 */
public class NameRunner {
	public static void main(String[] args) {
		theOldWay();
		theNewWay();
	}
	public static void theOldWay() {
		Name[] names=new Name[5];
		names[0]=new Name("Aaron","Braskin");
		names[1]=new Name();
		names[1].setFirst("Ken");
		names[1].setLast("Brenan");
		Name name=new Name("Aaron","Braskin");
		names[2]=name;
		names[3]=new Name("Ken",null);
		names[4]=new Name("Ken", "Brenan");
		System.out.println("Using a traditional for loop:");
		for (int i=0; i<names.length; i++) {
			System.out.println(names[i]);
		}
		System.out.println("Using a for each loop:");
		for (Name aName:names) {
			System.out.println(aName);
		}
	}
	public static void theNewWay() {
		List<Name> names=new ArrayList<Name>();
		Name name=new Name("Aaron","Braskin");
		names.add(name);
		names.add(new Name("Aaron","Braskin")); // Anonymous Instantiation
		name=new Name("Ken","Brenan");
		names.add(0, name);
		names.add(2,new Name("David","Connor"));
		// Using the get and size methods:
		System.out.println("Using a traditional for loop:");
		for (int i=0; i<names.size(); i++) {
			Name aName=names.get(i);
			System.out.println("names["+i+"]="+aName);
		}
		System.out.println("Using a for each loop:");
		for (Name aName:names) {
			System.out.println(aName);
		}
		// But wait, there's more...
		// The set method:
		printNames("Before Sets",names);
		Name movieCritic=new Name("Roger","Ebert");
		Name replacedName=names.set(2, movieCritic);
		names.add(1, replacedName);
		printNames("After Sets:",names);
		// The remove method:
		int rIndex=(int)(Math.random()*names.size());
		names.remove(rIndex);
		printNames("After Remove("+rIndex+")",names);
		System.out.println("There are currently "+names.size()+" names");
		// Now we use the equals method:
		System.out.println("Are there any duplicate names?");
		for (int i=0; i<names.size(); i++) {
			for (int j=i+1; j<names.size(); j++) {
				if (names.get(i).equals(names.get(j))) {
					System.out.println(names.get(i)+" is found at index "+i+" and "+j);
				}
			}
		}
	}
	public static void printNames(String title, List<Name> names) {
		System.out.println(title);
		for (int i=0; i<names.size(); i++) {
			System.out.println("names["+i+"]="+names.get(i));
		}
	}
}