/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.actor;

import info.gridworld.actor.Actor;
import info.gridworld.actor.Flower;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import java.awt.Color;

public class Bug
extends Actor {
    public Bug() {
        this.setColor(Color.RED);
    }

    public Bug(Color bugColor) {
        this.setColor(bugColor);
    }

    public void act() {
        if (this.canMove()) {
            this.move();
        } else {
            this.turn();
        }
    }

    public void turn() {
        this.setDirection(this.getDirection() + 45);
    }

    public void move() {
        Grid<Actor> gr = this.getGrid();
        if (gr == null) {
            return;
        }
        Location loc = this.getLocation();
        Location next = loc.getAdjacentLocation(this.getDirection());
        if (gr.isValid(next)) {
            this.moveTo(next);
        } else {
            this.removeSelfFromGrid();
        }
        Flower flower = new Flower(this.getColor());
        flower.putSelfInGrid(gr, loc);
    }

    public boolean canMove() {
        Grid<Actor> gr = this.getGrid();
        if (gr == null) {
            return false;
        }
        Location loc = this.getLocation();
        Location next = loc.getAdjacentLocation(this.getDirection());
        if (!gr.isValid(next)) {
            return false;
        }
        Actor neighbor = gr.get(next);
        return neighbor == null || neighbor instanceof Flower;
    }
}

