/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.actor;

import info.gridworld.actor.Actor;
import info.gridworld.actor.Rock;
import info.gridworld.grid.Location;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Critter
extends Actor {
    @Override
    public void act() {
        if (this.getGrid() == null) {
            return;
        }
        ArrayList<Actor> actors = this.getActors();
        this.processActors(actors);
        ArrayList<Location> moveLocs = this.getMoveLocations();
        Location loc = this.selectMoveLocation(moveLocs);
        this.makeMove(loc);
    }

    public ArrayList<Actor> getActors() {
        return this.getGrid().getNeighbors(this.getLocation());
    }

    public void processActors(ArrayList<Actor> actors) {
        for (Actor a : actors) {
            if (a instanceof Rock || a instanceof Critter) continue;
            a.removeSelfFromGrid();
        }
    }

    public ArrayList<Location> getMoveLocations() {
        return this.getGrid().getEmptyAdjacentLocations(this.getLocation());
    }

    public Location selectMoveLocation(ArrayList<Location> locs) {
        int n = locs.size();
        if (n == 0) {
            return this.getLocation();
        }
        int r = (int)(Math.random() * (double)n);
        return locs.get(r);
    }

    public void makeMove(Location loc) {
        if (loc == null) {
            this.removeSelfFromGrid();
        } else {
            this.moveTo(loc);
        }
    }
}

