/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.grid;

import info.gridworld.grid.AbstractGrid;
import info.gridworld.grid.Location;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedGrid<E>
extends AbstractGrid<E> {
    private Object[][] occupantArray;

    public BoundedGrid(int rows, int cols) {
        if (rows <= 0) {
            throw new IllegalArgumentException("rows <= 0");
        }
        if (cols <= 0) {
            throw new IllegalArgumentException("cols <= 0");
        }
        this.occupantArray = new Object[rows][cols];
    }

    @Override
    public int getNumRows() {
        return this.occupantArray.length;
    }

    @Override
    public int getNumCols() {
        return this.occupantArray[0].length;
    }

    @Override
    public boolean isValid(Location loc) {
        return 0 <= loc.getRow() && loc.getRow() < this.getNumRows() && 0 <= loc.getCol() && loc.getCol() < this.getNumCols();
    }

    @Override
    public ArrayList<Location> getOccupiedLocations() {
        ArrayList<Location> theLocations = new ArrayList<Location>();
        for (int r = 0; r < this.getNumRows(); ++r) {
            for (int c = 0; c < this.getNumCols(); ++c) {
                Location loc = new Location(r, c);
                if (this.get(loc) == null) continue;
                theLocations.add(loc);
            }
        }
        return theLocations;
    }

    @Override
    public E get(Location loc) {
        if (!this.isValid(loc)) {
            throw new IllegalArgumentException("Location " + loc + " is not valid");
        }
        return (E)this.occupantArray[loc.getRow()][loc.getCol()];
    }

    @Override
    public E put(Location loc, E obj) {
        if (!this.isValid(loc)) {
            throw new IllegalArgumentException("Location " + loc + " is not valid");
        }
        if (obj == null) {
            throw new NullPointerException("obj == null");
        }
        E oldOccupant = this.get(loc);
        this.occupantArray[loc.getRow()][loc.getCol()] = obj;
        return oldOccupant;
    }

    @Override
    public E remove(Location loc) {
        if (!this.isValid(loc)) {
            throw new IllegalArgumentException("Location " + loc + " is not valid");
        }
        E r = this.get(loc);
        this.occupantArray[loc.getRow()][loc.getCol()] = null;
        return r;
    }
}

