/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.gui;

import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import info.gridworld.gui.DisplayMap;
import info.gridworld.gui.GridPanel;
import info.gridworld.gui.MenuMaker;
import info.gridworld.gui.WorldFrame;
import info.gridworld.world.World;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUIController<T> {
    public static final int INDEFINITE = 0;
    public static final int FIXED_STEPS = 1;
    public static final int PROMPT_STEPS = 2;
    private static final int MIN_DELAY_MSECS = 10;
    private static final int MAX_DELAY_MSECS = 1000;
    private static final int INITIAL_DELAY = 505;
    private Timer timer;
    private JButton stepButton;
    private JButton runButton;
    private JButton stopButton;
    private JComponent controlPanel;
    private GridPanel display;
    private WorldFrame<T> parentFrame;
    private int numStepsToRun;
    private int numStepsSoFar;
    private ResourceBundle resources;
    private DisplayMap displayMap;
    private boolean running;
    private Set<Class> occupantClasses;

    public GUIController(WorldFrame<T> parent, GridPanel disp, DisplayMap displayMap, ResourceBundle res) {
        this.resources = res;
        this.display = disp;
        this.parentFrame = parent;
        this.displayMap = displayMap;
        this.makeControls();
        this.occupantClasses = new TreeSet<Class>(new Comparator<Class>(){

            @Override
            public int compare(Class a, Class b) {
                return a.getName().compareTo(b.getName());
            }
        });
        World<T> world = this.parentFrame.getWorld();
        Grid<T> gr = world.getGrid();
        for (Location loc : gr.getOccupiedLocations()) {
            this.addOccupant(gr.get(loc));
        }
        for (String name : world.getOccupantClasses()) {
            try {
                this.occupantClasses.add(Class.forName(name));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.timer = new Timer(505, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GUIController.this.step();
            }
        });
        this.display.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                Grid gr = GUIController.this.parentFrame.getWorld().getGrid();
                Location loc = GUIController.this.display.locationForPoint(evt.getPoint());
                if (loc != null && gr.isValid(loc) && !GUIController.this.isRunning()) {
                    GUIController.this.display.setCurrentLocation(loc);
                    GUIController.this.locationClicked();
                }
            }
        });
        this.stop();
    }

    public void step() {
        this.parentFrame.getWorld().step();
        this.parentFrame.repaint();
        if (++this.numStepsSoFar == this.numStepsToRun) {
            this.stop();
        }
        Grid<T> gr = this.parentFrame.getWorld().getGrid();
        for (Location loc : gr.getOccupiedLocations()) {
            this.addOccupant(gr.get(loc));
        }
    }

    private void addOccupant(T occupant) {
        Class<?> cl = occupant.getClass();
        do {
            if ((cl.getModifiers() & 0x400) != 0) continue;
            this.occupantClasses.add(cl);
        } while ((cl = cl.getSuperclass()) != Object.class);
    }

    public void run() {
        this.display.setToolTipsEnabled(false);
        this.parentFrame.setRunMenuItemsEnabled(false);
        this.stopButton.setEnabled(true);
        this.stepButton.setEnabled(false);
        this.runButton.setEnabled(false);
        this.numStepsSoFar = 0;
        this.timer.start();
        this.running = true;
    }

    public void stop() {
        this.display.setToolTipsEnabled(true);
        this.parentFrame.setRunMenuItemsEnabled(true);
        this.timer.stop();
        this.stopButton.setEnabled(false);
        this.runButton.setEnabled(true);
        this.stepButton.setEnabled(true);
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    private void makeControls() {
        this.controlPanel = new JPanel();
        this.stepButton = new JButton(this.resources.getString("button.gui.step"));
        this.runButton = new JButton(this.resources.getString("button.gui.run"));
        this.stopButton = new JButton(this.resources.getString("button.gui.stop"));
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
        this.controlPanel.setBorder(BorderFactory.createEtchedBorder());
        Dimension spacer = new Dimension(5, this.stepButton.getPreferredSize().height + 10);
        this.controlPanel.add(Box.createRigidArea(spacer));
        this.controlPanel.add(this.stepButton);
        this.controlPanel.add(Box.createRigidArea(spacer));
        this.controlPanel.add(this.runButton);
        this.controlPanel.add(Box.createRigidArea(spacer));
        this.controlPanel.add(this.stopButton);
        this.runButton.setEnabled(false);
        this.stepButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.controlPanel.add(Box.createRigidArea(spacer));
        this.controlPanel.add(new JLabel(this.resources.getString("slider.gui.slow")));
        JSlider speedSlider = new JSlider(10, 1000, 505);
        speedSlider.setInverted(true);
        speedSlider.setPreferredSize(new Dimension(100, speedSlider.getPreferredSize().height));
        speedSlider.setMaximumSize(speedSlider.getPreferredSize());
        for (InputMap map = speedSlider.getInputMap(); map != null; map = map.getParent()) {
            map.remove(KeyStroke.getKeyStroke("control PAGE_UP"));
            map.remove(KeyStroke.getKeyStroke("control PAGE_DOWN"));
        }
        this.controlPanel.add(speedSlider);
        this.controlPanel.add(new JLabel(this.resources.getString("slider.gui.fast")));
        this.controlPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIController.this.step();
            }
        });
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIController.this.run();
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIController.this.stop();
            }
        });
        speedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                GUIController.this.timer.setDelay(((JSlider)evt.getSource()).getValue());
            }
        });
    }

    public JComponent controlPanel() {
        return this.controlPanel;
    }

    private void locationClicked() {
        World<T> world = this.parentFrame.getWorld();
        Location loc = this.display.getCurrentLocation();
        if (loc != null && !world.locationClicked(loc)) {
            this.editLocation();
        }
        this.parentFrame.repaint();
    }

    public void editLocation() {
        World<T> world = this.parentFrame.getWorld();
        Location loc = this.display.getCurrentLocation();
        if (loc != null) {
            T occupant = world.getGrid().get(loc);
            if (occupant == null) {
                MenuMaker<T> maker = new MenuMaker<T>(this.parentFrame, this.resources, this.displayMap);
                JPopupMenu popup = maker.makeConstructorMenu(this.occupantClasses, loc);
                Point p = this.display.pointForLocation(loc);
                popup.show(this.display, p.x, p.y);
            } else {
                MenuMaker<T> maker = new MenuMaker<T>(this.parentFrame, this.resources, this.displayMap);
                JPopupMenu popup = maker.makeMethodMenu(occupant, loc);
                Point p = this.display.pointForLocation(loc);
                popup.show(this.display, p.x, p.y);
            }
        }
        this.parentFrame.repaint();
    }

    public void deleteLocation() {
        World<T> world = this.parentFrame.getWorld();
        Location loc = this.display.getCurrentLocation();
        if (loc != null) {
            world.remove(loc);
            this.parentFrame.repaint();
        }
    }
}

