/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.gui;

import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import info.gridworld.gui.DisplayMap;
import info.gridworld.gui.PropertySheet;
import info.gridworld.gui.WorldFrame;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuMaker<T> {
    private T occupant;
    private Grid currentGrid;
    private Location currentLocation;
    private WorldFrame<T> parent;
    private DisplayMap displayMap;
    private ResourceBundle resources;

    public MenuMaker(WorldFrame<T> parent, ResourceBundle resources, DisplayMap displayMap) {
        this.parent = parent;
        this.resources = resources;
        this.displayMap = displayMap;
    }

    public JPopupMenu makeMethodMenu(T occupant, Location loc) {
        this.occupant = occupant;
        this.currentLocation = loc;
        JPopupMenu menu = new JPopupMenu();
        Method[] methods = this.getMethods();
        Class<?> oldDcl = null;
        for (int i = 0; i < methods.length; ++i) {
            Class<?> dcl = methods[i].getDeclaringClass();
            if (dcl != Object.class) {
                if (i > 0 && dcl != oldDcl) {
                    menu.addSeparator();
                }
                menu.add(new MethodItem(methods[i]));
            }
            oldDcl = dcl;
        }
        return menu;
    }

    public JPopupMenu makeConstructorMenu(Collection<Class> classes, Location loc) {
        this.currentLocation = loc;
        JPopupMenu menu = new JPopupMenu();
        boolean first = true;
        Iterator<Class> iter = classes.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                menu.addSeparator();
            }
            Class cl = iter.next();
            Constructor<?>[] cons = cl.getConstructors();
            for (int i = 0; i < cons.length; ++i) {
                menu.add(new OccupantConstructorItem(cons[i]));
            }
        }
        return menu;
    }

    public void addConstructors(JMenu menu, Collection<Class> classes) {
        boolean first = true;
        Iterator<Class> iter = classes.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                menu.addSeparator();
            }
            Class cl = iter.next();
            Constructor<?>[] cons = cl.getConstructors();
            for (int i = 0; i < cons.length; ++i) {
                menu.add(new GridConstructorItem(cons[i]));
            }
        }
    }

    private Method[] getMethods() {
        Class<?> cl = this.occupant.getClass();
        Method[] methods = cl.getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                int d2;
                int d1 = this.depth(m1.getDeclaringClass());
                if (d1 != (d2 = this.depth(m2.getDeclaringClass()))) {
                    return d2 - d1;
                }
                int d = m1.getName().compareTo(m2.getName());
                if (d != 0) {
                    return d;
                }
                d1 = m1.getParameterTypes().length;
                d2 = m2.getParameterTypes().length;
                return d1 - d2;
            }

            private int depth(Class cl) {
                if (cl == null) {
                    return 0;
                }
                return 1 + this.depth(cl.getSuperclass());
            }
        });
        return methods;
    }

    private class MethodItem
    extends MCItem
    implements ActionListener {
        private Method m;

        public MethodItem(Method m) {
            this.setText(this.getDisplayString(m.getReturnType(), m.getName(), m.getParameterTypes()));
            this.m = m;
            this.addActionListener(this);
            this.setIcon(MenuMaker.this.displayMap.getIcon(m.getDeclaringClass(), 16, 16));
        }

        public void actionPerformed(ActionEvent event) {
            Class[] types = this.m.getParameterTypes();
            Object[] values = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                values[i] = this.makeDefaultValue(types[i]);
            }
            if (types.length > 0) {
                PropertySheet sheet = new PropertySheet(types, values);
                JOptionPane.showMessageDialog(this, sheet, MenuMaker.this.resources.getString("dialog.method.params"), 3);
                values = sheet.getValues();
            }
            try {
                Object result = this.m.invoke(MenuMaker.this.occupant, values);
                MenuMaker.this.parent.repaint();
                if (this.m.getReturnType() != Void.TYPE) {
                    Object resultObject;
                    String resultString = result.toString();
                    int MAX_LENGTH = 50;
                    int MAX_HEIGHT = 10;
                    if (resultString.length() < 50) {
                        resultObject = resultString;
                    } else {
                        int rows = Math.min(10, 1 + resultString.length() / 50);
                        JTextArea pane = new JTextArea(rows, 50);
                        pane.setText(resultString);
                        pane.setLineWrap(true);
                        resultObject = new JScrollPane(pane);
                    }
                    JOptionPane.showMessageDialog(MenuMaker.this.parent, resultObject, MenuMaker.this.resources.getString("dialog.method.return"), 1);
                }
            }
            catch (InvocationTargetException ex) {
                new WorldFrame.GUIExceptionHandler(MenuMaker.this.parent).handle(ex.getCause());
            }
            catch (Exception ex) {
                new WorldFrame.GUIExceptionHandler(MenuMaker.this.parent).handle(ex);
            }
        }
    }

    private class GridConstructorItem
    extends ConstructorItem
    implements ActionListener {
        public GridConstructorItem(Constructor c) {
            super(c);
            this.addActionListener(this);
            this.setIcon(MenuMaker.this.displayMap.getIcon(c.getDeclaringClass(), 16, 16));
        }

        public void actionPerformed(ActionEvent event) {
            Grid newGrid = (Grid)this.invokeConstructor();
            MenuMaker.this.parent.setGrid(newGrid);
        }
    }

    private class OccupantConstructorItem
    extends ConstructorItem
    implements ActionListener {
        public OccupantConstructorItem(Constructor c) {
            super(c);
            this.addActionListener(this);
            this.setIcon(MenuMaker.this.displayMap.getIcon(c.getDeclaringClass(), 16, 16));
        }

        public void actionPerformed(ActionEvent event) {
            Object result = this.invokeConstructor();
            MenuMaker.this.parent.getWorld().add(MenuMaker.this.currentLocation, result);
            MenuMaker.this.parent.repaint();
        }
    }

    private abstract class ConstructorItem
    extends MCItem {
        private Constructor c;

        public ConstructorItem(Constructor c) {
            this.setText(this.getDisplayString(null, c.getDeclaringClass().getName(), c.getParameterTypes()));
            this.c = c;
        }

        public Object invokeConstructor() {
            Class[] types = this.c.getParameterTypes();
            Object[] values = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                values[i] = this.makeDefaultValue(types[i]);
            }
            if (types.length > 0) {
                PropertySheet sheet = new PropertySheet(types, values);
                JOptionPane.showMessageDialog(this, sheet, MenuMaker.this.resources.getString("dialog.method.params"), 3);
                values = sheet.getValues();
            }
            try {
                return this.c.newInstance(values);
            }
            catch (InvocationTargetException ex) {
                new WorldFrame.GUIExceptionHandler(MenuMaker.this.parent).handle(ex.getCause());
                return null;
            }
            catch (Exception ex) {
                new WorldFrame.GUIExceptionHandler(MenuMaker.this.parent).handle(ex);
                return null;
            }
        }
    }

    private class MCItem
    extends JMenuItem {
        private MCItem() {
        }

        public String getDisplayString(Class retType, String name, Class[] paramTypes) {
            StringBuffer b = new StringBuffer();
            b.append("<html>");
            if (retType != null) {
                this.appendTypeName(b, retType.getName());
            }
            b.append(" <font color='blue'>");
            this.appendTypeName(b, name);
            b.append("</font>( ");
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                this.appendTypeName(b, paramTypes[i].getName());
            }
            b.append(" )</html>");
            return b.toString();
        }

        public void appendTypeName(StringBuffer b, String name) {
            int i = name.lastIndexOf(46);
            if (i >= 0) {
                String prefix = name.substring(0, i + 1);
                if (!prefix.equals("java.lang")) {
                    b.append("<font color='gray'>");
                    b.append(prefix);
                    b.append("</font>");
                }
                b.append(name.substring(i + 1));
            } else {
                b.append(name);
            }
        }

        public Object makeDefaultValue(Class type) {
            if (type == Integer.TYPE) {
                return new Integer(0);
            }
            if (type == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (type == Double.TYPE) {
                return new Double(0.0);
            }
            if (type == String.class) {
                return "";
            }
            if (type == Color.class) {
                return Color.BLACK;
            }
            if (type == Location.class) {
                return MenuMaker.this.currentLocation;
            }
            if (Grid.class.isAssignableFrom(type)) {
                return MenuMaker.this.currentGrid;
            }
            try {
                return type.newInstance();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

