/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class PseudoInfiniteViewport
extends JViewport {
    private JScrollPane scrollParent;
    private Point panPoint = new Point(0, 0);

    public PseudoInfiniteViewport(JScrollPane parent) {
        this.scrollParent = parent;
        this.setBackground(Color.lightGray);
    }

    public void setViewPosition(Point pt) {
        boolean isAdjusting = this.scrollParent.getVerticalScrollBar().getValueIsAdjusting() || this.scrollParent.getHorizontalScrollBar().getValueIsAdjusting();
        boolean changed = true;
        if (this.viewIsUnbounded()) {
            int hDelta = pt.x - this.panPoint.x;
            int vDelta = pt.y - this.panPoint.y;
            if (hDelta != 0 && vDelta == 0) {
                this.getPannableView().panBy(hDelta, vDelta);
            } else if (vDelta != 0 && hDelta == 0) {
                this.getPannableView().panBy(hDelta, vDelta);
            } else {
                changed = false;
            }
            this.panPoint = pt;
            if (!this.panPoint.equals(this.getPanCenterPoint()) && !isAdjusting) {
                this.panPoint = this.getPanCenterPoint();
                this.fireStateChanged();
            }
        } else {
            changed = !this.getViewPosition().equals(pt);
            super.setViewPosition(pt);
        }
        if (changed || isAdjusting) {
            this.getPannableView().showPanTip();
        }
    }

    public Point getViewPosition() {
        return this.viewIsUnbounded() ? this.getPanCenterPoint() : super.getViewPosition();
    }

    public Dimension getViewSize() {
        return this.viewIsUnbounded() ? this.getView().getPreferredSize() : super.getViewSize();
    }

    private Pannable getPannableView() {
        return (Pannable)((Object)this.getView());
    }

    private boolean viewIsUnbounded() {
        Pannable p = this.getPannableView();
        return p != null && p.isPannableUnbounded();
    }

    private Point getPanCenterPoint() {
        Dimension size = this.getViewSize();
        return new Point(size.width / 2, size.height / 2);
    }

    public static interface Pannable {
        public void panBy(int var1, int var2);

        public boolean isPannableUnbounded();

        public void showPanTip();
    }
}

