/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.world;

import info.gridworld.grid.BoundedGrid;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import info.gridworld.gui.WorldFrame;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class World<T> {
    private Grid<T> gr;
    private Set<String> occupantClassNames;
    private Set<String> gridClassNames;
    private String message;
    private JFrame frame;
    private static Random generator = new Random();
    private static final int DEFAULT_ROWS = 10;
    private static final int DEFAULT_COLS = 10;

    public World() {
        this(new BoundedGrid(10, 10));
        this.message = null;
    }

    public World(Grid<T> g) {
        this.gr = g;
        this.gridClassNames = new TreeSet<String>();
        this.occupantClassNames = new TreeSet<String>();
        this.addGridClass("info.gridworld.grid.BoundedGrid");
        this.addGridClass("info.gridworld.grid.UnboundedGrid");
    }

    public void show() {
        if (this.frame == null) {
            this.frame = new WorldFrame(this);
            this.frame.setVisible(true);
        } else {
            this.frame.repaint();
        }
    }

    public Grid<T> getGrid() {
        return this.gr;
    }

    public void setGrid(Grid<T> newGrid) {
        this.gr = newGrid;
        this.repaint();
    }

    public void setMessage(String newMessage) {
        this.message = newMessage;
        this.repaint();
    }

    public String getMessage() {
        return this.message;
    }

    public void step() {
        this.repaint();
    }

    public boolean locationClicked(Location loc) {
        return false;
    }

    public boolean keyPressed(String description, Location loc) {
        return false;
    }

    public Location getRandomEmptyLocation() {
        int c;
        int r;
        Location loc;
        Grid<T> gr = this.getGrid();
        int rows = gr.getNumRows();
        int cols = gr.getNumCols();
        if (rows > 0 && cols > 0) {
            ArrayList<Location> emptyLocs = new ArrayList<Location>();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    Location loc2 = new Location(i, j);
                    if (!gr.isValid(loc2) || gr.get(loc2) != null) continue;
                    emptyLocs.add(loc2);
                }
            }
            if (emptyLocs.size() == 0) {
                return null;
            }
            int r2 = generator.nextInt(emptyLocs.size());
            return (Location)emptyLocs.get(r2);
        }
        while (!gr.isValid(loc = new Location(r = rows < 0 ? (int)(10.0 * generator.nextGaussian()) : generator.nextInt(rows), c = cols < 0 ? (int)(10.0 * generator.nextGaussian()) : generator.nextInt(cols))) || gr.get(loc) != null) {
        }
        return loc;
    }

    public void add(Location loc, T occupant) {
        this.getGrid().put(loc, occupant);
        this.repaint();
    }

    public T remove(Location loc) {
        T r = this.getGrid().remove(loc);
        this.repaint();
        return r;
    }

    public void addGridClass(String className) {
        this.gridClassNames.add(className);
    }

    public void addOccupantClass(String className) {
        this.occupantClassNames.add(className);
    }

    public Set<String> getGridClasses() {
        return this.gridClassNames;
    }

    public Set<String> getOccupantClasses() {
        return this.occupantClassNames;
    }

    private void repaint() {
        if (this.frame != null) {
            this.frame.repaint();
        }
    }

    public String toString() {
        String s = "";
        Grid<T> gr = this.getGrid();
        int rmin = 0;
        int rmax = gr.getNumRows() - 1;
        int cmin = 0;
        int cmax = gr.getNumCols() - 1;
        if (rmax < 0 || cmax < 0) {
            for (Location loc : gr.getOccupiedLocations()) {
                int r = loc.getRow();
                int c = loc.getCol();
                if (r < rmin) {
                    rmin = r;
                }
                if (r > rmax) {
                    rmax = r;
                }
                if (c < cmin) {
                    cmin = c;
                }
                if (c <= cmax) continue;
                cmax = c;
            }
        }
        for (int i = rmin; i <= rmax; ++i) {
            for (int j = cmin; j < cmax; ++j) {
                T obj = gr.get(new Location(i, j));
                s = obj == null ? s + " " : s + obj.toString().substring(0, 1);
            }
            s = s + "\n";
        }
        return s;
    }
}

