import java.util.List;
import java.util.ArrayList;
/** This class will Introduce the primitive type wrapper classes in Java */
public class WrapperRunner {
	public static void main(String[] args) {
		// Instantiated an ArrayList object using the default constructor of the ArrayList class
		List<Object> myObjectList=new ArrayList<Object>();
		/* Java Primitive Types (AP Subset): int, double, boolean */
		/* Working with Integer Wrapper Class */
		// Standard Instantiation of an Integer using the Constructor
		Integer anIntegerWrapper=new Integer(5);
		myObjectList.add(anIntegerWrapper);
		myObjectList.add("An Integer instantiated normally using the constructor");
		
		int anInt=anIntegerWrapper.intValue(); // "Unwraps" the Integer
		// Autoboxing and Unboxing
		myObjectList.add(anInt); // Java has Autoboxed my primitive int into an Integer
		myObjectList.add("Java has Autoboxed my primitive int into an Integer");
		
		int anotherInt=anIntegerWrapper; // Java has Unboxed my Integer into an Int primitive using the .intValue() method
		myObjectList.add(anotherInt);
		myObjectList.add("Java has Unboxed my Integer into an Int primitive using the .intValue() method");
		
		// Find the largest and smallest possible value that can be stored in an int or Integer
		int smallestInt=Integer.MIN_VALUE; // Found the smallest value using Integer.MIN_VALUE
		myObjectList.add(smallestInt);
		myObjectList.add("Found the smallest value using Integer.MIN_VALUE");
		
		Integer largestInteger=Integer.MAX_VALUE;
		myObjectList.add(largestInteger);
		myObjectList.add("Largest value found using Integer.MAX_VALUE");
		
		String s="1235";
		int whatNumberIsIt=Integer.parseInt(s);
		myObjectList.add(whatNumberIsIt);
		myObjectList.add("A Number created using Integer.parseInt(String)");
		
		/* Working with the Double Wrapper Class */
		// Add Double using MAX_VALUE (and String after it)
		myObjectList.add(Double.MAX_VALUE);
		myObjectList.add("Double using MAX_VALUE");
		// Add Double using MIN_VALUE
		myObjectList.add(Double.MIN_VALUE);
		myObjectList.add("Double using MIN_VALUE");
		// Add Double using Double.parseDouble(String)
		myObjectList.add(Double.parseDouble("123.456"));
		myObjectList.add("Double using Double.parseDouble(String)");
		// Add Double using Standard Instantiation
		myObjectList.add(new Double("12345.6789"));
		myObjectList.add("Double using Standard Instantiation");
		
		for (Object someObject : myObjectList) {
			// Print the Type:Value associated String
			if (someObject instanceof Integer) {
				System.out.print("Integer: ");
			} else if (someObject instanceof Double) {
				System.out.print("Double: ");
			}
			System.out.print(someObject+" ");
			if (someObject instanceof String) {
				System.out.println();
			}
		}
	}
}








